local iPN = ...;
assert(iPN,"[Graphics/PaneDisplay text.lua] No PlayerNumber Provided.");
local difcolor=GetUserPref_Theme("UserDifficultyColor");

local t = Def.ActorFrame {};
if not GAMESTATE:IsPlayerEnabled(iPN) then
	return t;
end;
local function GetRadarData( pnPlayer, rcRadarCategory )
	local tRadarValues;
	local StepsOrTrail;
	local fDesiredValue = 0;
	if GAMESTATE:GetCurrentSteps( pnPlayer ) then
		StepsOrTrail = GAMESTATE:GetCurrentSteps( pnPlayer );
		fDesiredValue = StepsOrTrail:GetRadarValues( pnPlayer ):GetValue( rcRadarCategory );
	elseif GAMESTATE:GetCurrentTrail( pnPlayer ) then
		StepsOrTrail = GAMESTATE:GetCurrentTrail( pnPlayer );
		fDesiredValue = StepsOrTrail:GetRadarValues( pnPlayer ):GetValue( rcRadarCategory );
	else
		StepsOrTrail = nil;
	end;
	return fDesiredValue;
end;

local exsong_inf={};
local exsong_fol={};
local sys_selsong=1;
local sys_load=false;
local function CreatePaneDisplayItem( _pnPlayer, _sLabel, _rcRadarCategory, _sleepTime )
	return Def.ActorFrame {
		OnCommand=function(self)
			self:diffusealpha(0);
			self:zoom(1.3);
			self:addx((iPN==PLAYER_1) and -40 or 40);
			self:addy(-20);
			self:sleep(_TT.S_IN+0.5+_sleepTime);
			self:accelerate(0.3);
			self:zoom(1.0);
			self:addx((iPN==PLAYER_1) and 40 or -40);
			self:addy(20);
			self:diffusealpha(1);
		end;
		OffCommand=cmd(diffusealpha,1);
		LoadFont("Common Normal") .. {
			Text=string.upper( THEME:GetString("PaneDisplay",_sLabel) );
			InitCommand=cmd(horizalign,right;x,2;maxwidth,40/0.55;diffuse,D3Color("Red");
				strokecolor,Color("White"));
			OnCommand=cmd(zoom,0.55;);
			SetCommand=function(self)
				song=_SONG();
				if GAMESTATE:GetCurrentSteps(iPN) then
					dif=GAMESTATE:GetCurrentSteps(iPN):GetDifficulty();
				end;
				self:skewx(-0.1);
			end;
		};
		LoadFont("Common Normal") .. {
			Text="000";
			InitCommand=cmd(x,38;horizalign,right;diffuse,D3Color("Red");
				strokecolor,Color("White"));
			OnCommand=function(self)
				self:zoom(0.6);
				self:skewx(-0.1);
				self:queuecommand("Set");
			end;
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong()
				if not song then
					self:settext("000");
					self:diffusealpha(0.3);
				elseif not sys_load or bitand(exsong_inf[exsong_fol[sys_selsong].."-Hidden"],1)==1 then
					self:settext("???");
					self:diffusealpha(0.3);
				else
					self:settextf("%03i", GetRadarData( _pnPlayer, _rcRadarCategory ) );
					if GetRadarData( _pnPlayer, _rcRadarCategory )==0 then
						self:diffusealpha(0.3);
					else
						self:diffusealpha(1);
					end;
				end
			end;
		};
	};
end;

--[[ Numbers ]]
local song=nil;
local dif=nil;
t[#t+1] = Def.ActorFrame {
	FOV=90;
	OnCommand=cmd(playcommand,"Set");
	SetCommand=function(self)
		song=_SONG();
		if GAMESTATE:GetCurrentSteps(iPN) then
			dif=GAMESTATE:GetCurrentSteps(iPN):GetDifficulty();
		end;
	end;
	LoadActor(getenv("D3MIXMode") and THEME:GetPathG("_SelectMusic/blue frame","pane")
		or THEME:GetPathG("_SelectMusic/frame","pane"))..{
	};
	CreatePaneDisplayItem( iPN, "Taps", 'RadarCategory_TapsAndHolds' ,0.0) .. {
		InitCommand=cmd(x,0;y,-32);
	};
	CreatePaneDisplayItem( iPN, "Jumps", 'RadarCategory_Jumps' ,0.05) .. {
		InitCommand=cmd(x,0;y,-19);
	};
	CreatePaneDisplayItem( iPN, "Holds", 'RadarCategory_Holds' ,0.1) .. {
		InitCommand=cmd(x,0;y,-6);
	};
	CreatePaneDisplayItem( iPN, "Mines", 'RadarCategory_Mines' ,0.15) .. {
		InitCommand=cmd(x,0;y,7);
	};
	CreatePaneDisplayItem( iPN, "Rolls", 'RadarCategory_Rolls' ,0.2) .. {
		InitCommand=cmd(x,0;y,20);
	};
	CreatePaneDisplayItem( iPN, "Lifts", 'RadarCategory_Lifts' ,0.25) .. {
		InitCommand=cmd(x,0;y,33);
	};
	CreatePaneDisplayItem( iPN, "Hands", 'RadarCategory_Hands' ,0.3) .. {
		InitCommand=cmd(x,0;y,46);
	};
	--[[
	CreatePaneDisplayItem( iPN, "Fakes", 'RadarCategory_Fakes' ,0.35) .. {
		InitCommand=cmd(x,0;y,52);
	};
	--]]
};
setenv("pane_chg",false);
local old_step=nil;
local function update(self)
	if _SONG() then
		local st=_STEPS2(iPN);
		if old_step~=st then
			old_step=st;
			sys_selsong=getenv("sys_selsong");
			self:playcommand("Set");
		end;
	else
		if old_step~=nil then
			old_step=nil;
			sys_selsong=getenv("sys_selsong");
			self:playcommand("Set");
		end;
	end;
	if not sys_load and getenv("exsong_flag")=="decorations" then
		exsong_inf=getenv("exsong_inf");
		exsong_fol=getenv("exsong_fol");
		sys_selsong=getenv("sys_selsong");
		sys_load=true;
		self:queuecommand("Set");
	end;
	if getenv("exsong_chg") and not getenv("pane_chg") then
		sys_selsong=getenv("sys_selsong");
		setenv("pane_chg",true);
		self:queuecommand("Set");
	end;
end;
t.InitCommand=cmd(SetUpdateFunction,update);
return t;